/*****************************************************************************
* SecureUpdate_DLL.H
*
* Description: Contains the function prototypes for the exported API's to End User.
*
******************************************************************************/

#include "SentinelKeystypes.h"

#if defined(WIN32)
SP_STATUS __declspec(dllexport) WINAPI SFNTGenerateRequestCode ( SP_IN     SP_DWORD    DeveloperID,
                                     SP_IN      SP_DWORD     licenseID, 
                                     SP_OUT     SPP_BYTE    requestBuffer, 
                                     SP_INOUT   SPP_DWORD   bufferSize);

typedef (WINAPI *TSFNTGenerateRequestCodeFnPtr)(SP_DWORD    DeveloperID, 
                                                SP_DWORD     licenseID,
                                                SPP_BYTE    requestBuffer,
                                                SPP_DWORD   bufferSize);

SP_STATUS  __declspec(dllexport) WINAPI SFNTApplyUpdateCode ( SP_IN SPP_BYTE    updateCode, 
                                 SP_IN SP_DWORD    size);

typedef (WINAPI *TSFNTApplyUpdateCodeFnPtr)(SPP_BYTE  updateCode,
                                            SP_DWORD  size);
#else
unsigned short SFNTGenerateRequestCode ( SP_IN      SP_DWORD    DeveloperID,
                                         SP_IN      SP_DWORD    licenseID, 
                                         SP_OUT     SPP_BYTE    requestBuffer, 
                                         SP_INOUT   SPP_DWORD   bufferSize);

typedef  unsigned short (*TSFNTGenerateRequestCodeFnPtr)(SP_DWORD    DeveloperID, 
                                                         SP_DWORD    licenseID,
                                                         SPP_BYTE    requestBuffer,
                                                         SPP_DWORD   bufferSize);

unsigned short SFNTApplyUpdateCode ( SP_IN SPP_BYTE    updateCode, 
                                     SP_IN SP_DWORD    size);

typedef unsigned short (*TSFNTApplyUpdateCodeFnPtr)(SPP_BYTE  updateCode,
                                                    SP_DWORD  size);     
#endif                                                                                           